#include <io.h>
#include <system.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define RADIUS 8 //ball radius
#define PI 3.14159265
#define PADDLE_X 160 
#define PADDLE_WIDTH 10
#define BULLET_WIDTH 10

void chooseGame();
void getFrequency(int current_sample);
int collision(double ball_x_center, double ball_y_center, int paddle_top, int paddle_height);

//Variables for frequency algorithm
int *periods;
int on = 0;                    //if on = 1, signal is hi, we are counting consectutive hi's
int sound = 0;                  //if 0, there is no sound coming in (only noise)
int silences = 0;               //number of consecutive "silent" samples
int consec_hi = 0;              //number of consecutive hi samples
int consec_lo = 0;              //number of consecutive lo samples               
int replaceIndex = 0;              //Index of periods array in which to place current index
int output = 176;                 //Sum of periods array
int avgNum=50;                  //Number of period measurements to store at once
//Overall Game controls
int gameStarted=0;          //Turns to 1 when paddle control option is chosen
int myScore=0;              //User score
int compScore=0;            //"Computer" score
int option =1;              //1 if frequency control, 0 if paddle control

//Bullet control variables
int bulletInFlight=0;       //Bullet has been fired
int bulletX;                //Bullet X Coordinate
int bulletY;                //Bullet Y Coordinate
int bulletCharged=0;        //Increments from 0 to 3 while bullet is charged

//Paddle control
int paddleDirection=0;      //0 if not moving, 1 if moving down, -1 if up
int paddle_top=200;         //Y coordinate of top of paddle
int paddle_height=100;      //length of paddle
//Ball Control
int angle_of_motion=30;     //Direction (degrees)
double ball_x_center=180;   //X Coordinate
double ball_y_center=90;    //Y Coordinate
int speed = 5;              //Magnitude of speed

//Delay variables
int loops_per_repaint=500;  //Number of iterations between execution of ball/paddle/bullet control
int count = 0;              //Count variable to track iterations

int main()
{
    int i;
    int compBlock[] = {1,1,1,1,1,1}; //Keep track of which blocks are destroyed
    periods= (int*)malloc(sizeof(int)*avgNum); //Array of the last avgNum results of the freq. algorithm
    //Initialized to 8 (to start as an average frequency)
    for (i = 0 ; i < avgNum ; i++)
    {
        periods[i]=8;
    }
    
    //Clean raster registers
    for (i = 0 ; i < 32 ; i++)
    {
        IOWR_16DIRECT(RASTER_BASE, i, 0x0100);
    }
    
    
    chooseGame();
    int maxOut=0;
    int minOut=1000;
    for(;;) 
    {
        //Get sound byte from audio controller
        int soundByte = IORD_16DIRECT(AUDIOSLAVE_BASE,0);
        
        //Call frequency algorithm
        getFrequency(soundByte);
 
        //Implement delay (don't execute every iteration)
        if ( count++ == loops_per_repaint ) 
        {

            count = 0;
        }
        if ( count %loops_per_repaint == 1 )
        {
            if(option) //Frequency controlled paddle
            {
                    if(!sound) //Silence, don't move
                        paddleDirection = 0;
                    else if(output/avgNum < 20) //Low periods, move up
                       paddleDirection = 1;
                   else if(output/avgNum > 30) //High periods, move down
                      paddleDirection = -1;
            
                    if(paddleDirection == 1 && paddle_top > 38) //Paddle not already at top
                        paddle_top -= 5;
                    else if(paddleDirection == -1 && paddle_top < 412) //paddle not already at bottom
                        paddle_top += 5;
            }  
            else //Noise controlled paddle
                if(sound) //Noise detected
                {   
                    
                    if(paddle_top < 412)
                        paddle_top +=3;
                }
                else //Silence detected
                {   
                    if(paddle_top > 38)
                        paddle_top -=2;
                }
                      
                            
            if(bulletInFlight) //Bullet has been fired
            {
                if(bulletX + 15 >=750) //Bullet reaches X level of blocks
                {
                    //If a bullet hits the blocks at a boundary, it can destroy two blocks
                    int blockIndex1 = (bulletY - 38)/79;
                    int blockIndex2 = (bulletY + BULLET_WIDTH - 38)/79;
                    
                    compBlock[blockIndex1] = 0;
                    compBlock[blockIndex2] = 0;
                    bulletInFlight = 0;
                }
                else
                    bulletX+=4;
            }
            else //Bullet possibly charging
            {
                //keep bullet aligned with center of paddle as paddle moves
                bulletY = paddle_top + paddle_height/2;
                bulletX = PADDLE_X;
            }
               
            
            
            //Ball collides with top of screen 
            if ( ball_y_center - RADIUS < 38 )
            {//Reflect direction
                angle_of_motion = -angle_of_motion;
                ball_y_center = 39 +RADIUS;
            }
            //Ball collides with bottom of screen
            if ( ball_y_center + RADIUS > 512 )
            {
                angle_of_motion = -angle_of_motion;
                ball_y_center = 511 - RADIUS;
            } 
            //Ball moves left past the paddle
            if ( ball_x_center - RADIUS < 170 - RADIUS )
            {
                //Computer scores
                compScore++;
                //Reset blocks, bullet, ball
                bulletCharged = 0;
                bulletInFlight = 0;
                ball_x_center=180;
                ball_y_center=90;
                angle_of_motion = 30;
                for(i=0;i<6;i++)
                        compBlock[i] = 1;
            }
            //Ball reaches blocks on right
            if( ball_x_center + RADIUS > 750 ) 
            {
                //Check which blocks it is making contact with
                int blockIndex1 = (ball_y_center+RADIUS - 38)/79;
                int blockIndex2 = (ball_y_center-RADIUS - 38)/79;
                
                //if blocks have not been destroyed, reflect ball
                if(compBlock[blockIndex1] || compBlock[blockIndex2])
                    angle_of_motion = -angle_of_motion + 180;
                else //Ball found a gap between blocks
                {
                    //User scores, reset ball, bullets and blocks
                    myScore++;
                    bulletCharged = 0;
                    bulletInFlight = 0;
                    ball_x_center=180;
                    ball_y_center=90;
                    angle_of_motion = 30;
                    for(i=0;i<6;i++)
                        compBlock[i] = 1;
                }
            }
            //Check if ball in contact with paddle
            int collision_redirect = collision(ball_x_center, ball_y_center, paddle_top, paddle_height);
                
            if(collision_redirect != -1) //Ball is in contact with paddle
            {                    
                if(bulletCharged < 3) //Continue charging bullet
                    bulletCharged++;
                else //Bullet fully charged, fire bullet
                {
                    bulletInFlight = 1;
                    bulletCharged = 0;
                }
                //Deflect ball at angle calculated by collision method (paddle gradient)
                angle_of_motion = collision_redirect;
            }
            angle_of_motion = angle_of_motion % 360;
            
            //Update ball position using trigonometry
            ball_x_center = ball_x_center + speed*cos(PI*angle_of_motion/180);
            ball_y_center = ball_y_center + speed*sin(PI*angle_of_motion/180);
            
            //Rewrite registers
            IOWR_16DIRECT(RASTER_BASE, 0x0004, (int)ball_x_center );
            IOWR_16DIRECT(RASTER_BASE, 0x0000, (int)ball_y_center );
            IOWR_16DIRECT(RASTER_BASE, 0x0002,paddle_top);
            IOWR_16DIRECT(RASTER_BASE, 0x0006,myScore);
            IOWR_16DIRECT(RASTER_BASE, 0x0008,compScore);
            IOWR_16DIRECT(RASTER_BASE, 0x000A,compBlock[0]);
            IOWR_16DIRECT(RASTER_BASE, 0x000C,compBlock[1]);
            IOWR_16DIRECT(RASTER_BASE, 0x000E,compBlock[2]);
            IOWR_16DIRECT(RASTER_BASE, 0x0010,compBlock[3]);
            IOWR_16DIRECT(RASTER_BASE, 0x0012,compBlock[4]);
            IOWR_16DIRECT(RASTER_BASE, 0x0014,compBlock[5]);
            IOWR_16DIRECT(RASTER_BASE, 0x0016,bulletInFlight);
            IOWR_16DIRECT(RASTER_BASE, 0x0018,bulletCharged);
            IOWR_16DIRECT(RASTER_BASE, 0x001A,bulletX);
            IOWR_16DIRECT(RASTER_BASE, 0x001C,bulletY);
            
            //Game is over
            if(myScore==5 || compScore==5)
            {
                //reset score, choose new game
                 myScore = 0;
                 compScore = 0;
                 gameStarted=0;
                 paddle_top = 200;
                chooseGame();
            }
        }
    }
    return 0;
}

int collision(double ball_x_center, double ball_y_center, int paddle_top, int paddle_height)
{//Returns the (positive) degree at which to project the ball
 //Returns -1 if no collision
    if(ball_x_center - RADIUS <= PADDLE_X+PADDLE_WIDTH) //Ball crosses vertical line of paddle
    {
        if( (ball_y_center + RADIUS >= paddle_top) && (ball_y_center -RADIUS <=paddle_top + paddle_height)) //Ball in contact with paddle
        {//(ball_y_center - paddle_top)/paddle_height = (redirect_angle/140) - 70
            //Implements paddle gradient per above equation
            int redirect_angle;
            redirect_angle = (int)((ball_y_center - paddle_top)/paddle_height*140)-70;
            return redirect_angle;
        }
    }
    return -1;
}
void chooseGame()
{//Paddle moves based on frequency, if moved to top of screen, noise control chosen, else frequency controlled
    while(!gameStarted)
    {
         int soundByte;
        //Read sound byte from the avalon bus
        soundByte = IORD_16DIRECT(AUDIOSLAVE_BASE,0);
        getFrequency(soundByte);
        
        if ( count++ == 1000 ) 
        {
            count = 0;
        }
        if ( count %1000 == 1 )//Only execute every 1000 iterations        
        {
            //printf("%d\n",output);
            if(!sound) //Silence, don't move
                paddleDirection = 0;
            else if(output/avgNum < 20) //Low periods, move up
                paddleDirection = 1;
            else if(output/avgNum > 30) //High periods, move down
                paddleDirection = -1;
            
            if(paddleDirection == 1 && paddle_top > 38) //Paddle not already at top
                paddle_top -= 3;
            else if(paddleDirection == -1 && paddle_top < 412) //paddle not already at bottom
                paddle_top += 3;
            
            if(paddle_top < 45) //Paddle reaches top, choose noise control
            {
                option = 0;
                gameStarted = 1;
            }
            if(paddle_top > 400) //Paddle reaches bottom, choose frequency control
            {
                option = 1;
                gameStarted = 1;
            }
            IOWR_16DIRECT(RASTER_BASE, 0x0002,paddle_top); //Output paddle height to VGA
        } 
    }
}
void getFrequency(int current_sample)
{//current_sample is a int representation of a wav sound btye
           
    if(current_sample < 100 || current_sample > 65436 || (current_sample> 32000 && current_sample < 33000) )       //any thing of smaller magnitude is background noise    
    {
        silences++;
        if(silences > 50)  //50 consecutive silent notes                                 
            sound = 0;
    }
    else
    {
        sound = 1;
        silences = 0;
    }
    if(sound) //Sound is being played
    {
        if(on) //Last sound byte was positive
        {
            if(current_sample < 32768) //Positive means first bit is 1
                consec_hi = consec_hi + 1;
            else //The end of a positive string
            {
                on = 0;
                //Next 3 lines place consecutive high bytes in periods array and update sum of the array (output)
                if(consec_hi > 10)
                {
                    output += consec_hi;
                    //printf("high %d\n",consec_hi); 
                    output -= periods[replaceIndex];
                    periods[replaceIndex] = consec_hi;
                
                    replaceIndex= (replaceIndex+1)%avgNum;
                }
                consec_hi = 0;
            }
        }
        else
        {//Analogous to preceding if block
            if(current_sample >= 32768)
                consec_lo=consec_lo+1;
            else
            {
               
                on=1;
                if(consec_lo > 10)
                {
                    output += consec_lo;
                    //printf("low %d\n",consec_lo);
                    output -= periods[replaceIndex];
                    periods[replaceIndex] = consec_lo;
                    replaceIndex= (replaceIndex+1)%avgNum;
                }
                consec_lo = 0;
            }
           
        }
    }
    
}
